(function() {
  define(['jquery', 'underscore', 'Handlebars', 'Backbone', 'mobiscroll', 'collections/project/ProjectCollection', "views/menu/MenuView", 'views/project/ProjectListView', 'views/contact/ContactListView', 'PrecompiledTemplates'], function($, _, Handlebars, Backbone, Mobiscroll, ProjectCollection, MenuView, ProjectListView, ContactListView) {
    var FormTodoView;
    return FormTodoView = class FormTodoView extends Backbone.View {
      initialize(usr, todo, context) {
        var wasAssignedToID, wasLinkedToID;
        this.usr = usr;
        this.todo = todo;
        this.context = context;
        //      console.log @todo.toJSON()
        wasAssignedToID = this.todo.get('assignedToID');
        wasLinkedToID = this.todo.get('linkedToID');
        this.todo.set({
          'wasAssignedToID': wasAssignedToID
        });
        this.todo.set({
          'wasLinkedToID': wasLinkedToID
        });
        return this.todo.on('todoSaved', this.__refresh_and_change_page, this);
      }

      events() {
        return {
          'tap #id-btn-back': 'btnBackClicked',
          'tap #id-btn-todo-completed': 'btnTodoCompletedClicked',
          'tap #id-btn-todo-declined': 'btnTodoDeclinedClicked',
          'tap #id-btn-todo-priority': 'btnTodoPriorityClicked',
          'tap .edit-replyNote': 'btnShowReplyNoteForm',
          'tap #id-btn-todo-done-replyNote': 'btnSaveReplyNoteClicked',
          'tap .edit-todo-note': 'btnShowNoteForm',
          'tap #id-btn-todo-done-note': 'btnSaveNoteClicked',
          'tap #id-btn-todo-date': 'btnDateClicked',
          'tap #id-btn-todo-set-time': 'btnSetTimeClicked',
          'tap #id-btn-todo-time': 'btnTimeClicked',
          'tap .edit-todo-title': 'btnShowTitleSelectorClicked',
          'tap #id-btn-done-name-todo': 'btnDoneTitleClicked',
          'change input[name=radio-title]': 'btnRadioTitleChanged',
          'change #id-input-todo-date': 'dateChanged',
          'change #id-input-todo-time': 'timeChanged',
          'change #id-select-todo-alarm': 'alarmChanged',
          'tap #id-todo-project': 'btnAddTodoProjectClicked',
          'tap #id-todo-related-to': 'btnContactRelatedClicked',
          'tap #id-todo-assigned-to': 'btnContactAssignedClicked',
          'tap #id-btn-save-todo': 'btnSaveTodoClicked'
        };
      }

      render() {
        var template;
        template = Handlebars.templates['FormTodoView'];
        // PRECAUTION - JUST IN CASE CRAAZY API DONT SENT THESE PARAMETERS
        if (!this.todo.get('isDone')) {
          this.todo.set({
            'isDone': 0
          });
        }
        if (!this.todo.get('declined')) {
          this.todo.set({
            'declined': 0
          });
        }
        this.$el.html(template({
          context: this.context,
          todo: this.todo.toJSON(),
          todoTitleList: this.todo.get_structure_titles(),
          amPm: parseInt(this.usr.get('usesAMPM'), 10)
        }));
        if (this.__has_todos_permission()) {
          this.$el.find('#id-row-add-project').show();
        } else {
          this.$el.find('#id-row-add-project').hide();
        }
        this.$el.find('#id-spinner-all').hide();
        this.addSidePanel();
        return this.$el.attr('id', 'id-FormTodoView');
      }

      addSidePanel() {
        if (window.media_query_min_width(768)) {
          if (!MenuView) {
            MenuView = require("views/menu/MenuView");
          }
          this.panel = new MenuView(this.usr, this.obj);
          this.panel.render();
          return this.$el.append(this.panel.el);
        }
      }

      btnBackClicked(event) {
        event.preventDefault();
        event.stopPropagation();
        return $.mobile.jqmNavigator.popView({
          transition: 'none'
        });
      }

      btnShowTitleSelectorClicked(event) {
        event.preventDefault();
        event.stopPropagation();
        this.$el.find('#id-titletodo-form').show();
        this.$el.find('#id-div-todo-form').hide();
        this.$el.find('#id-btn-done-name-todo').show();
        return this.$el.find('#id-btn-save-todo').hide();
      }

      btnDoneTitleClicked(event) {
        var title;
        event.preventDefault();
        event.stopPropagation();
        title = this.$el.find('#id-input-todo-title').val();
        this.todo.set({
          'title': title
        });
        this.$el.find('#id-input-todo-title').val(title);
        this.$el.find('#id-titletodo-form').hide();
        this.$el.find('#id-div-todo-form').show();
        this.$el.find('#id-btn-done-name-todo').hide();
        this.$el.find('#id-btn-save-todo').show();
        return this.$el.find("#id-p-title").text(title);
      }

      btnRadioTitleChanged(event) {
        var title;
        event.preventDefault();
        event.stopPropagation();
        title = $(event.currentTarget).val();
        this.todo.set({
          'title': title
        });
        this.$el.find('#id-input-todo-title').val(title);
        this.$el.find('#id-titletodo-form').hide();
        this.$el.find('#id-div-todo-form').show();
        this.$el.find("#id-p-title").text(title);
        this.$el.find('#id-btn-done-name-todo').hide();
        return this.$el.find('#id-btn-save-todo').show();
      }

      btnShowReplyNoteForm(event) {
        event.preventDefault();
        event.stopPropagation();
        this.$el.find('#id-input-todo-replyNote').text(this.todo.get('replyNote'));
        return this.$el.find('#id-div-form-replyNote').show();
      }

      btnSaveReplyNoteClicked(event) {
        var note;
        event.preventDefault();
        event.stopPropagation();
        note = this.$el.find('#id-input-todo-replyNote').val();
        this.todo.set({
          'replyNote': note
        });
        this.$el.find('#id-p-replyNote').text(note);
        return this.$el.find('#id-div-form-replyNote').hide();
      }

      btnShowNoteForm(event) {
        event.preventDefault();
        event.stopPropagation();
        this.$el.find('#id-input-todo-note').text(this.todo.get('note'));
        return this.$el.find('#id-div-form-note').show();
      }

      btnSaveNoteClicked(event) {
        var note;
        event.preventDefault();
        event.stopPropagation();
        note = this.$el.find('#id-input-todo-note').val();
        this.todo.set({
          'note': note
        });
        this.$el.find('#id-p-note').text(note);
        return this.$el.find('#id-div-form-note').hide();
      }

      btnTodoCompletedClicked(event) {
        var btn, completed, isDone;
        event.preventDefault();
        event.stopPropagation();
        btn = $(event.currentTarget);
        completed = btn.attr('data-completed');
        if (completed === '1') {
          isDone = 0;
          btn.attr('data-completed', '0');
          btn.find('.ui-btn-text').text('No');
          btn.removeClass('btnTodoCompleted');
        } else {
          isDone = 1;
          btn.attr('data-completed', '1');
          btn.find('.ui-btn-text').text('Yes');
          btn.addClass('btnTodoCompleted');
        }
        return this.todo.set({
          'isDone': isDone
        });
      }

      btnTodoDeclinedClicked(event) {
        var btn, declined;
        event.preventDefault();
        event.stopPropagation();
        btn = $(event.currentTarget);
        declined = btn.attr('data-declined');
        if (declined === '1') {
          declined = 0;
          btn.attr('data-declined', '0');
          btn.find('.ui-btn-text').text('No');
          btn.removeClass('btnTodoDeclined');
        } else {
          declined = 1;
          btn.attr('data-declined', '1');
          btn.find('.ui-btn-text').text('Yes');
          btn.addClass('btnTodoDeclined');
        }
        return this.todo.set({
          'declined': declined
        });
      }

      btnTodoPriorityClicked(event) {
        var btn, prio, prior;
        event.preventDefault();
        event.stopPropagation();
        btn = $(event.currentTarget);
        prio = btn.attr('data-priority');
        if (prio === '1') {
          prior = 0;
          btn.attr('data-priority', '0');
          btn.find('.ui-btn-text').text('No');
          btn.removeClass('btnTodoCompleted');
        } else {
          prior = 1;
          btn.attr('data-priority', '1');
          btn.find('.ui-btn-text').text('Yes');
          btn.addClass('btnTodoCompleted');
        }
        return this.todo.set({
          'priority': prior
        });
      }

      btnSetTimeClicked(event) {
        var btn, setTime;
        event.stopPropagation();
        event.preventDefault();
        btn = $(event.currentTarget);
        setTime = btn.attr('data-set-time');
        if (setTime === '1') {
          btn.attr('data-set-time', '0');
          btn.find('.ui-btn-text').text('No');
          btn.removeClass('btnTodoCompleted');
          this.$el.find('.div-todo-time').addClass('ui-disabled');
          this.$el.find('.div-todo-alarm').addClass('ui-disabled');
          this.todo.set('forDate', this.todo.get('forDateAndTime'));
          this.todo.unset('forDateAndTime', {
            silent: true
          });
          if (this.todo.get('alarmMinutesBefore')) {
            return this.todo.unset('alarmMinutesBefore');
          }
        } else {
          btn.attr('data-set-time', '1');
          btn.find('.ui-btn-text').text('Yes');
          btn.addClass('btnTodoCompleted');
          this.$el.find('.div-todo-time').removeClass('ui-disabled');
          this.$el.find('.div-todo-alarm').removeClass('ui-disabled');
          this.todo.set('forDateAndTime', this.todo.get('forDate'));
          return this.todo.unset('forDate', {
            silent: true
          });
        }
      }

      btnTimeClicked(event) {
        var input, timeOptions;
        event.stopPropagation();
        event.preventDefault();
        input = this.$el.find('#id-input-todo-time');
        timeOptions = {
          theme: 'iOS',
          display: 'bottom',
          onChange: this.__validate
        };
        if (parseInt(this.usr.get('usesAMPM'), 10) === 0) {
          timeOptions['timeFormat'] = 'H:ii';
          timeOptions['timeWheels'] = 'Hii';
        } else {
          timeOptions['timeFormat'] = 'h:ii A';
          timeOptions['timeWheels'] = 'hii A';
        }
        $(input).mobiscroll().time(timeOptions);
        return $(input).mobiscroll('show');
      }

      btnDateClicked(event) {
        var input, options;
        event.stopPropagation();
        event.preventDefault();
        input = this.$el.find('#id-input-todo-date');
        options = {
          theme: 'iOS',
          display: 'bottom',
          dateFormat: 'yy-mm-dd',
          dateOrder: 'ddmmyy',
          maxDate: window.MAXDATE
        };
        $(input).mobiscroll().date(options);
        return $(input).mobiscroll('show');
      }

      dateChanged(event) {
        var dt, dtAndTime, input, time;
        event.stopPropagation();
        event.preventDefault();
        input = $(event.currentTarget);
        dt = input.val();
        dtAndTime = dt + ' 00:00:00';
        if (this.$el.find('#id-btn-todo-time').find('.ui-btn-text').text() === 'Yes') {
          time = this.$el.find('#id-input-todo-time').val();
          dtAndTime = dt + " " + time;
          this.todo.set({
            'forDateAndTime': dtAndTime
          });
        } else {
          this.todo.set({
            'forDate': dtAndTime
          });
        }
        return this.$el.find('#id-btn-todo-date').find('.ui-btn-text').text(Handlebars.helpers.beautyDateForTodos(dt));
      }

      timeChanged(event) {
        var dtAndTime, input, tm;
        event.stopPropagation();
        event.preventDefault();
        input = $(event.currentTarget);
        tm = input.val();
        dtAndTime = this.$el.find('#id-input-todo-date').val().split(" ")[0] + ' ' + tm;
        this.todo.set({
          'forDateAndTime': dtAndTime
        });
        this.todo.unset('forDate', {
          silent: true
        });
        return this.$el.find('#id-btn-todo-time').find('.ui-btn-text').text(tm);
      }

      alarmChanged(event) {
        var alarm, sel;
        event.stopPropagation();
        event.preventDefault();
        sel = $(event.currentTarget);
        alarm = sel.val();
        if (alarm !== 'off') {
          return this.todo.set({
            'alarmMinutesBefore': alarm
          });
        } else {
          return this.todo.unset('alarmMinutesBefore');
        }
      }

      btnAddTodoProjectClicked(event) {
        var nextView, projectCol;
        event.stopPropagation();
        event.preventDefault();
        if (!ProjectCollection) {
          ProjectCollection = require('collections/project/ProjectCollection');
        }
        if (!ProjectListView) {
          ProjectListView = require('views/project/ProjectListView');
        }
        projectCol = new ProjectCollection();
        projectCol.get_projects(this.usr);
        nextView = new ProjectListView(this.usr, projectCol, 'AddTodo');
        return $.mobile.jqmNavigator.pushView(nextView, {
          transition: 'none'
        });
      }

      addedTodoProject(view, prjMdl) {
        view.print_project_added(prjMdl);
        view.todo.set({
          'projectID': prjMdl.get('id'),
          'projectName': prjMdl.get('name')
        });
        return $.mobile.jqmNavigator.popView({
          transition: 'none'
        });
      }

      print_project_added(prj) {
        this.$el.find('#id-todo-project').attr('data-projectID', prj.get('id'));
        return this.$el.find('#id-todo-project').find('.ui-btn-text').text(prj.get('name'));
      }

      btnContactAssignedClicked(event) {
        var view;
        event.stopPropagation();
        event.preventDefault();
        if (!ContactListView) {
          ContactListView = require('views/contact/ContactListView');
        }
        view = new ContactListView(this.usr, 'AddTodoAssigned');
        return $.mobile.jqmNavigator.pushView(view, {
          transition: 'none'
        });
      }

      btnContactRelatedClicked(event) {
        var view;
        event.stopPropagation();
        event.preventDefault();
        if (!ContactListView) {
          ContactListView = require('views/contact/ContactListView');
        }
        view = new ContactListView(this.usr, 'AddTodoRelated');
        return $.mobile.jqmNavigator.pushView(view, {
          transition: 'none'
        });
      }

      addedContactTodo(view, prevView, contact) {
        view.print_contact_added(contact, prevView);
        return $.mobile.jqmNavigator.popView({
          transition: 'none'
        });
      }

      print_contact_added(contact, prevView) {
        var btn, name;
        name = contact.get('Contact').firstName + ' ' + contact.get('Contact').lastName;
        if (prevView === 'AddTodoRelated') {
          btn = this.$el.find('#id-todo-related-to');
          this.todo.set({
            'linkedToID': contact.get('Contact').contactID,
            'linkedToName': name,
            'linkedToCompanyName': contact.get('Contact').companyName,
            'contactID': contact.get('Contact').contactID,
            'contactName': name,
            'contactCompanyName': contact.get('Contact').companyName
          });
        } else if (prevView === 'AddTodoAssigned') {
          btn = this.$el.find('#id-todo-assigned-to');
          this.todo.set({
            'addedToUserID': contact.get('Contact').contactID,
            'addedToUserName': name,
            'assignedToID': contact.get('Contact').contactID,
            'assignedToName': name
          });
        }
        btn.attr('data-userID', contact.get('Contact').contactID);
        return btn.find('.ui-btn-text').text(name);
      }

      btnSaveTodoClicked(event) {
        event.stopPropagation();
        event.preventDefault();
        return this.todo.save_todo(this.usr);
      }

      __has_todos_permission() {
        return this.usr.__show_todos_all_projects() || this.usr.__show_todos_division_projects() || this.usr.__show_todos_relation_projects();
      }

      __refresh_and_change_page(ev) {
        return $.mobile.jqmNavigator.popView({
          transition: 'none'
        });
      }

    };
  });

}).call(this);
